C +----------------------------------------------------------------------+
C | MAR post-processing XF                                  06/01/2003   | 
C |                                                              v.3.0   |
C | Surf                                                                 |
C |                                                                      |
C +----------------------------------------------------------------------+
C
      SUBROUTINE Surf(idRLS, idMAR, itM, itR, istat,
     $                InReg, MARlon, MARlat, jhuCUR,
     $                MAPtyp, iOUTnc,idt1)

      IMPLICIT NONE
 
C +...* dimensions :
      include 'NSTdim.inc'
      include 'NSTtoMAP.inc'
      
C +...* MAPOST specific (nreg...)
      include 'MAPOST.inc'
      include 'LSMphy.inc'

C +...* Internal values of Surf (retain for next call):
      include 'Surf.inc'

C +---INPUT
C +   ~~~~~
      INTEGER idMAR, itM, idRLS, itR
      INTEGER InReg(mx,my,nreg)
      REAL MARlon(mx,my), MARlat(mx,my)
      INTEGER istat,jhuCUR,MAPtyp,iOUTnc,idt1

C +---OUTPUT 
C +   ~~~~~~
C     (none)

C +---LOCAL
C +   ~~~~~
      CHARACTER *10 vUnits, tmp_units
C +-  -Coordonnees:
      REAL LSlon(LSni), LSlat(LSnj), LSlev(LSnk)
      REAL MARx(mx), MARy(my), empty1(1), sigma(mz)
      REAL ptop, CSTpMA(mzz), SIGpMA(mzz)
      REAL CSTp (LSnk1), SIGp (LSnk1), wkzRLS(LSnk)
C +-  -Valeurs lues
      REAL shMAR(mx,my), shRLS(LSni,LSnj), shIRLS(mx,my)
      REAL PlspRLS(LSni,LSnj), Pcp_RLS(LSni,LSnj)
      REAL Psf_RLS(LSni,LSnj), LSM_LS (LSni,LSnj)
      REAL Plspold(LSni,LSnj), Pcp_old(LSni,LSnj)
      REAL Psf_old(LSni,LSnj)
      REAL T2_MAR(mx,my)
      REAL T2_RLS (LSni,LSnj)
      REAL ALB_MAR(mx,my)
      REAL ALB_RLS (LSni,LSnj) 
C +-  -Intermediaires de calcul
      REAL Rrr_MAR(nreg), Rcp_MAR(nreg),Rsf_MAR(nreg),Rtot_MAR(nreg)
      REAL RrrIRLS(nreg), RcpIRLS(nreg),RsfIRLS(nreg),RtotIRLS(nreg)
      REAL rrIRLS(mx,my), cpIRLS(mx,my),sfIRLS(mx,my),totIRLS(mx,my)
      REAL T2IRLS(mx,my)
      REAL ALBIRLS(mx,my) 
      REAL rT2IRLS(nreg), rT2_MAR(nreg), rTmiMAR(nreg)
      REAL rALBIRLS(nreg), rALB_MAR(nreg) 
      REAL rTmaMAR(nreg)
      REAL TOTmaxMAR
      logical stat_t2, rainCA_OK

C +-  -Indices, ...
      INTEGER kl, ii, jj, nelem, ireg
      INTEGER ildt, ilstat

C +---Read general MAR data     
C +   ---------------------

      CALL UNread
     &   (idMAR, 'sh', 0,0, 1,1,mx,my,1,
     &    MARx, MARy, empty1, vUnits, shMAR)

C +---Read general RLS data       
C +   ---------------------
      CALL UNread
     &   (idRLS, 'SH', 0,0, 1,1,LSni,LSnj,1,
     &    LSlon, LSlat, empty1, vUnits, shRLS)

      CALL INThor (-1, LSlon , LSlat , shRLS,
     &                 MARlon, MARlat, shIRLS)


C +===Precipitation.
C +   ==============

C +   IF variable is not available, warn and set=0.0:
C +   (NOVAR_WARN level 1 = replace and warn, don't stop)
      CALL UNparam('NOVAR_REPLACE',0.0)
      CALL UNparam('NOVAR_WARNING',1.0)

C +- -RLS/ERA
C +   - - - - - - - - - -
C +   ERA (ECMWF) => from 6 hour to current (??) LSP- 
C         PxxxRLS variables = Period (usually 6 hour) data
C         (! usually more MAR data then RLS=> ok. 
C          more RLS would not be allowed: missing period)

      if (itR > 2 ) then
       Plspold = PlspRLS
       Pcp_old = Pcp_RLS
       Psf_old = Psf_RLS             
      end if

      CALL UNsread
     &   (idRLS,'LSP'   ,itR,0, 
     &    1,1,LSni,LSnj,1, vUnits,PlspRLS) !Large Scale

      CALL UNsread
     &   (idRLS,'CP'     ,itR,0,
     &    1,1,LSni,LSnj,1, vUnits,Pcp_RLS) !Convective

      CALL UNsread
     &   (idRLS,'SF'     ,itR,0,
     &    1,1,LSni,LSnj,1, vUnits,Psf_RLS) !Snow Fall


c    WARNING - WARNING - WARNING - WARNING - WARNING

      if (itR == 1) then
       print *, " "
       print *, "WARNING: Precipitation only for Greenland (XF)"
       print *, " "
       PlspRLS = 0.
       Pcp_RLS = 0.
       Psf_RLS = 0.
      end if

C     Option 1
      if (mod(itR,2) == 0 ) then
       PlspRLS = 0.                         
       Pcp_RLS = 0.                        
       Psf_RLS = 0.                        
      end if

C     Option 2
c02   if (mod(itR,2) \= 0 .and. itR > 2 ) then
c02    PlspRLS = max(0., PlspRLS - Plspold) 
c02    Pcp_RLS = max(0., Pcp_RLS - Pcp_old)
c02    Psf_RLS = max(0., Psf_RLS - Psf_old)
c02   end if
      

c   1981 -> 1989
c Si on est le 1 mai 1983 dans le fichier ECM (Forecast Precipitation).
c - La 1re entre est les prcips cumules sur 12h depuis le 30 avril  12h.
c - La 2me entre est les prcips cumules sur 6h  depuis le 1  mai    00h.
c - La 3me entre est les prcips cumules sur 12h depuis le 1  mai    00h.
c - La 4me entre est les prcips cumules sur 6h  depuis le 1  mai    12h.
 
c   1989 => 1993
c Si on est le 1 mai 1991 dans le fichier ECM (Forecast Precipitation).  
c - La 1re entre est les prcips cumules sur 12h depuis le 30 avril  12h. 
c - La 2me entre est les prcips cumules sur 18h depuis le 30 avril  12h. 
c - La 3me entre est les prcips cumules sur 12h depuis le 1  mai    00h. 
c - La 4me entre est les prcips cumules sur 18h depuis le 1  mai    00h.

c => Il faut mettre 0 au premier pas de temps.
c => Option1: Soit ne compter qu'un pas de temps sur deux pour le cumul 
c             (prcip 12h et pas 18h)
c => Option2: Soit extraire au pas de temps 12h, le pas de temps prcdent 6h. 

C +   *Compute cumulated precipitation:

      CALL Cumul (PlspRLS, LSni, LSnj, istat, lspRLS)
      CALL Cumul (Pcp_RLS, LSni, LSnj, istat, cp_RLS)
      CALL Cumul (Psf_RLS, LSni, LSnj, istat, sf_RLS)

      DO jj=1,LSnj
      DO ii=1,LSni
         rr_RLS(ii,jj) =  lspRLS(ii,jj) + cp_RLS(ii,jj)
     .                 -  sf_RLS(ii,jj)
        tot_RLS(ii,jj) =  lspRLS(ii,jj) + cp_RLS(ii,jj)      
      ENDDO
      ENDDO

C +- -MAR
C +   - - - - - - - - - -
C +   MAR=> Cumulated -> use end of month

      CALL UNsread
     &   (idMAR,'rainHY' ,itM,0,
     &    1,1,mx  ,my  ,1, vUnits,rr_MAR) !Total Rain

      if (itR==1) rainCA_OK=.true.

      if (rainCA_OK) then
       CALL UNsread
     &    (idMAR,'rainCA' ,itM,0,
     &     1,1,mx  ,my  ,1, vUnits,cp_MAR) !Convective
      end if
      
      DO jj=1,my ; DO ii=1,mx; if(abs(cp_MAR(ii,jj))>10000)then     
       rainCA_OK = .false. 
      end if ; enddo ; enddo

      CALL UNsread
     &   (idMAR,'snowHY' ,itM,0,
     &    1,1,mx  ,my  ,1, vUnits,sf_MAR) !Snow Fall
    
       DO jj=1,my
       DO ii=1,mx
         tot_MAR(ii,jj) =  rr_MAR(ii,jj) + sf_MAR(ii,jj)
       ENDDO
       ENDDO

C +. -Memorize initial value for "cumulated rain" in MAR
C     - - - - - - - - - - - - - - - - - - - - - - - - - -
      IF (istat.EQ.0) THEN
       DO jj=1,my
       DO ii=1,mx
         rr_iMAR(ii,jj) =  rr_MAR(ii,jj)
       ENDDO
       ENDDO
      ENDIF

      IF (istat.EQ.0) THEN
       DO jj=1,my
       DO ii=1,mx
         cp_iMAR(ii,jj) =  cp_MAR(ii,jj)
       ENDDO
       ENDDO
      ENDIF

      IF (istat.EQ.0) THEN
       DO jj=1,my
       DO ii=1,mx
         sf_iMAR(ii,jj) =  sf_MAR(ii,jj)
       ENDDO
       ENDDO
      ENDIF

      IF (istat.EQ.0) THEN
       TOTmaxMAR=0.0
       DO jj=1,my
       DO ii=1,mx
         tot_iMAR(ii,jj) =  tot_MAR(ii,jj)
         TOTmaxMAR = max(TOTmaxMAR, tot_MAR(ii,jj))
       ENDDO
       ENDDO
       IF (TOTmaxMAR.GE.0.001) THEN
       write(*,*) 'WARNING (Surf.f):'
       write(*,*) '  Total MAR precip is not 0 at run start'
       write(*,*) '  (this may be ok). Max. init. is', TOTmaxMAR
       ENDIF
      ENDIF

C +. -Write instant. values of RegM[RR] (time)
C     - - - - - - - - - - - - - - - - - - - - -
      CALL HORmean (InReg, rr_MAR, Rrr_MAR)
      CALL UNwrite (iOUTnc, 'r_RR_M', idt1,nreg,1,1, Rrr_MAR)

      CALL HORmean (InReg, sf_MAR, Rsf_MAR)
      CALL UNwrite (iOUTnc, 'r_SF_M', idt1,nreg,1,1, Rsf_MAR)

      CALL HORmean (InReg, tot_MAR, Rtot_MAR)
      CALL UNwrite (iOUTnc, 'r_TOT_M', idt1,nreg,1,1, Rtot_MAR)

      CALL HORmean (InReg, cp_MAR, Rcp_MAR)
      CALL UNwrite (iOUTnc, 'r_CP_M', idt1,nreg,1,1, Rcp_MAR)

      CALL INThor (-1, LSlon , LSlat , rr_RLS,
     &                 MARlon, MARlat, rrIRLS)
      CALL HORmean (InReg, rrIRLS, RrrIRLS)
      CALL UNwrite (iOUTnc, 'r_RR_R', idt1,nreg,1,1, RrrIRLS)

      CALL INThor (-1, LSlon , LSlat , sf_RLS,
     &                 MARlon, MARlat, sfIRLS)
      CALL HORmean (InReg, sfIRLS, RsfIRLS)
      CALL UNwrite (iOUTnc, 'r_SF_R', idt1,nreg,1,1, RsfIRLS)

      CALL INThor (-1, LSlon , LSlat , tot_RLS,
     &                 MARlon, MARlat, totIRLS)
      CALL HORmean (InReg, totIRLS, RtotIRLS)
      CALL UNwrite (iOUTnc, 'r_TOT_R', idt1,nreg,1,1, RtotIRLS)

      CALL INThor (-1, LSlon , LSlat , cp_RLS,
     &                 MARlon, MARlat, cpIRLS)
      CALL HORmean (InReg, cpIRLS, RcpIRLS)
      CALL UNwrite (iOUTnc, 'r_CP_R', idt1,nreg,1,1, RcpIRLS)


C +---Last time-step only: get cumulated value + write.
C +   -------------------------------------------------
      IF (istat.EQ.2) THEN

        DO jj=1,my
        DO ii=1,mx
          rr_MAR(ii,jj) =  rr_MAR(ii,jj) - rr_iMAR(ii,jj)
        ENDDO
        ENDDO

        DO jj=1,my
        DO ii=1,mx
          sf_MAR(ii,jj) =  sf_MAR(ii,jj) - sf_iMAR(ii,jj)
        ENDDO
        ENDDO
        
        DO jj=1,my
        DO ii=1,mx       
          cp_MAR(ii,jj) =  cp_MAR(ii,jj) - cp_iMAR(ii,jj)       
        ENDDO
        ENDDO

        DO jj=1,my
        DO ii=1,mx
          tot_MAR(ii,jj) =  tot_MAR(ii,jj) - tot_iMAR(ii,jj)
        ENDDO
        ENDDO

        CALL UNwrite (iOUTnc, 'C_RR_M', 1, mx, my, 1, rr_MAR)
        CALL UNwrite (iOUTnc, 'C_RR_R', 1, mx, my, 1, rrIRLS)                
        CALL UNwrite (iOUTnc, 'C_CP_M', 1, mx, my, 1, CP_MAR)        
        CALL UNwrite (iOUTnc, 'C_CP_R', 1, mx, my, 1, cpIRLS)     
        CALL UNwrite (iOUTnc, 'C_SF_M', 1, mx, my, 1, sf_MAR)        
        CALL UNwrite (iOUTnc, 'C_SF_R', 1, mx, my, 1, sfIRLS)             
        CALL UNwrite (iOUTnc, 'C_TOT_M', 1, mx, my, 1, tot_MAR)        
        CALL UNwrite (iOUTnc, 'C_TOT_R', 1, mx, my, 1, totIRLS)   
        

        CALL TransGrid  (MAPtyp,
     &      MARlon, MARlat, MARx, MARy, rr_MAR,
     &      LSlon, LSlat, rr_TMAR)

        CALL UNwrite (iOUTnc, 'C_RR_LR', 0,LSni,LSnj,1,rr_RLS)
        CALL UNwrite (iOUTnc, 'C_RR_LM', 0,LSni,LSnj,1,rr_TMAR)    

        CALL TransGrid  (MAPtyp,
     &      MARlon, MARlat, MARx, MARy, cp_MAR,
     &      LSlon, LSlat, cp_TMAR)

        CALL UNwrite (iOUTnc, 'C_CP_LR', 0,LSni,LSnj,1,cp_RLS)
        CALL UNwrite (iOUTnc, 'C_CP_LM', 0,LSni,LSnj,1,cp_TMAR)  

        CALL TransGrid  (MAPtyp,
     &      MARlon, MARlat, MARx, MARy, sf_MAR,
     &      LSlon, LSlat, sf_TMAR)

        CALL UNwrite (iOUTnc, 'C_SF_LR', 0,LSni,LSnj,1,sf_RLS)
        CALL UNwrite (iOUTnc, 'C_SF_LM', 0,LSni,LSnj,1,sf_TMAR)    

        CALL TransGrid  (MAPtyp,
     &      MARlon, MARlat, MARx, MARy, tot_MAR,
     &      LSlon, LSlat, tot_TMAR)

        CALL UNwrite (iOUTnc, 'C_TOT_LR', 0,LSni,LSnj,1,tot_RLS)
        CALL UNwrite (iOUTnc, 'C_TOT_LM', 0,LSni,LSnj,1,tot_TMAR) 

      ENDIF

C +===Surface Albedo
C +   ==============

      CALL UNsread (idRLS,'AL',itR,0,
     &    1,1,LSni,LSnj,1, vUnits,ALB_RLS) 

      CALL UNsread (idMAR,'albeSL',itM,0, 
     &    1,1,mx  ,my  ,1, vUnits,ALB_MAR) 

C +. -Interpolate RLS values to MAR grid.
C     - - - - - - - - - - - - - - - - - - - - -
      CALL INThor (-1, LSlon , LSlat , ALB_RLS,
     &                 MARlon, MARlat, ALBIRLS)


C +- -Compute & write tM[ALB] & tSD[ALB]
C     - - - - - - - - - - - - - - - - - - -

      CALL HDynSTA2D(iOUTnc,istat,idt1,ALB_MAR,
     &               'tM_al_M','tSD_al_M',tM_al_M,tSD_al_M)
      CALL HDynSTA2D(iOUTnc,istat,idt1,ALBIRLS,
     &               'tM_al_R','tSD_al_R',tM_al_R,tSD_al_R)


C +. -Write instant. values of RegM[alb] (time)
C     - - - - - - - - - - - - - - - - - - - - -
      CALL HORmean (InReg, ALBIRLS, rALBIRLS)
      CALL UNwrite (iOUTnc, 'rM_al_R'  , idt1,nreg,1,1, rALBIRLS)


      CALL HORmean (InReg, ALB_MAR, rALB_MAR)
      CALL UNwrite (iOUTnc, 'rM_al_M'  , idt1,nreg,1,1, rALB_MAR)

C +===2m air temperature.
C +   ===================

C +- -RLS/ERA
C +   - - - - 
      CALL UNsread (idRLS,'2T'   ,itR,0,
     &    1,1,LSni,LSnj,1, vUnits,T2_RLS) !2m Temp       


C +- -MAR
C +   - - 
      CALL UNsread (idMAR,'Ta2mSL',itM,0,
     &    1,1,mx  ,my  ,1, vUnits,T2_MAR) !2m Temp

C +   -* T_min and _max are valid only at 6h in current MAR
C +      (may change with versions: complicated algorithm.)
C 
C       De toute facon, Tmin/max ici = pas au point !
C       (notamment : ecrit pour journee suivante ds fichier...)
 
      IF (jhuCUR.EQ.6) THEN

c       CALL UNsread (idMAR,'TminSL',itM,0,
c    &    1,1,mx  ,my  ,1, vUnits,TmiMAR) !2m min T

c       CALL UNsread (idMAR,'TmaxSL',itM,0,
c    &    1,1,mx  ,my  ,1, vUnits,TmaMAR) !2m max T
   
      ENDIF


C +. -Interpolate RLS values to MAR grid.      
C     - - - - - - - - - - - - - - - - - - - - -
      CALL INThor (-1, LSlon , LSlat , T2_RLS,
     &                 MARlon, MARlat, T2IRLS)
C +   Optional: attempt to correct the LS value for the
C +   topo difference => go to MAR sh using -6.5 K/km grad:
      DO jj=1,my
      DO ii=1,mx
         T2IRLS(ii,jj) = T2IRLS(ii,jj)
     &                 + gamTz*(shMAR(ii,jj)-shIRLS(ii,jj)) 
      ENDDO
      ENDDO
      IF (istat.EQ.2) THEN
        write(*,*) 'INFO: T air 2m: rough cor. for topo dif. ON'
      ENDIF


C +. -Write instant. values of RegM[T2m] (time)
C     - - - - - - - - - - - - - - - - - - - - -
      CALL HORmean (InReg, T2IRLS, rT2IRLS)
      CALL UNwrite (iOUTnc, 'rT2_R'  , idt1,nreg,1,1, rT2IRLS)


      CALL HORmean (InReg, T2_MAR, rT2_MAR)
      CALL UNwrite (iOUTnc, 'rT2_M'  , idt1,nreg,1,1, rT2_MAR)

c     CALL HORmean (InReg, TmiMAR, rTmiMAR)
c     CALL UNwrite (iOUTnc, 'rT2minM', idt1,nreg,1,1, rTmiMAR)

c     CALL HORmean (InReg, TmaMAR, rTmaMAR)
c     CALL UNwrite (iOUTnc, 'rT2maxM', idt1,nreg,1,1, rTmaMAR)
 

C +. -Compute & write mean temperature.            
C     - - - - - - - - - - - - - - - - -
C     (This routine was created for HDyn, but is perfect 
C      also here...)
C
      ildt  = idt1-1
      ilstat= istat
      IF (idt1.LE.2) ilstat = 0
C     ^The first data does not exist, so reset stats to 0
C      after ther first step (cause: MAR calc of T2)

      CALL HDynSTVAL (iOUTnc,ilstat,ildt,rT2IRLS,
     &               'tM_T2_R',tMT2RLS)

      CALL HDynSTVAL (iOUTnc,ilstat,ildt,rT2_MAR,
     &               'tM_T2_M',tMT2MAR)

c     CALL HDynSTVAL (iOUTnc,ilstat,ildt,rTmiMAR,
c    &               'tM_TmiM',tMTmiMAR)

c     CALL HDynSTVAL (iOUTnc,ilstat,ildt,rTmaMAR,
c    &               'tM_TmaM',tMTmaMAR)


C +===Copy LS Land Sea Mask for graphics
C +   ==================================
      IF (istat.EQ.2) THEN

         CALL UNsread (idRLS,'LSM',0,0,
     &       1,1,LSni,LSnj,1, vUnits,LSM_LS)

         CALL UNwrite (iOUTnc,'LSM_L', 0,LSni,LSnj,1,LSM_LS)

      ENDIF
      
C +   Go back to standard treatment of missing variables:
C +   (warn level 2 = standard = stop all)
      CALL UNparam('NOVAR_WARNING',2.0)


C +- -Observations (GPCC) 
C +   - - - - - - - - - -
C     (Cumulated / one month)
C     ! Currently read directly from IDL !
c     nfile = '.nc'
c     CALL UNropen (nfile, idOBS, OBStit)
c     CALL UNsread
c    &   (idMAR,'RR' ,0,0,
c    &    1,1,mx  ,my  ,1, vUnits,rr_OBS) !Total Rain
c     CALL NCCLOS(idOBS, iError)

      RETURN
      END
