C +----------------------------------------------------------------------+
C | MAR post-processing                                       3.0.0      |
C |                                                                      |
C | SetRegs                                                              |
C |  Defines the averaging sub-regions.                                  |
C |  (InReg(ii,jj,ireg)=1 if point (ii,jj) belongs to reg # ireg)        |
C | WARNING: InReg is an INTEGER                                         |
C |                                                                      |
C |  ireg = 1-10 => internally defined                                   |
C |       > 10   => Lon/Lat sub-regions limits from file                 |
C |                 21 : isol = 1,2,3,4                                  |
C |                 22 : isol = 1,2                                      |
C |                 23 : isol = 3                                        |
C |                 24 : isol = 4                                        |
C |                                                                      |
C |  Under development:                                                  |
C |     definition of surface observation stations                       |
C |    wmSta (mx,my,nsta)  ! Weight of MAR value -> this station         |
C | WARNING: wmSTA is a REAL                                             |
C |                                                                      |
C +----------------------------------------------------------------------+
C
C +
      SUBROUTINE SetRegs (MARisol,MARlon,MARlat,InReg,RegMsk,
     .                    wmSTA,StaMsk)
      
      IMPLICIT NONE
      
C +---LS and MAR domain dimensions :
C +   -----------------------------
      INCLUDE 'NSTdim.inc'
      INCLUDE 'NSTtoMAP.inc'

      include 'globals.inc'
      include 'MAPOST.inc'
      
      REAL MARisol(mx,my), MARlon(mx,my), MARlat(mx,my)
      REAL aLat, aLon, bLat, bLon
      INTEGER InReg(mx,my,nreg)
      REAL RegMsk(mx,my)
      INTEGER ii, jj, iexcl, iSpecReg, ista, ireg
      CHARACTER*21 INPstr
      CHARACTER*80 RegDFile

C +   For the stations:
      REAL wmSta (mx,my,nsta)  ! Weight of MAR value -> this station
      REAL StaMsk(mx,my)
      
      iexcl   = 10
C +...Number of excluded near-boundary points.

      iSpecReg= 11 - 1
C +...Sets the number of the first automatic. def. region 

      DO ireg=1,nreg
        DO jj= 1,my
        DO ii= 1,mx
          InReg(ii,jj,ireg)= 0
        ENDDO
        ENDDO
      ENDDO

      DO jj= 1,my
      DO ii= 1,mx
         RegMsk(ii,jj)= 0
      ENDDO
      ENDDO

      ireg= iSpecReg + 1
C +...All points except excluded boundary
        DO jj= iexcl,my-iexcl
        DO ii= iexcl,mx-iexcl
          InReg(ii,jj,ireg)= 1
        ENDDO
        ENDDO

      ireg= iSpecReg + 2
C +...All LAND or TUNDRA points except excluded boundary
        DO jj= iexcl,my-iexcl
        DO ii= iexcl,mx-iexcl
          IF (NINT(MARisol(ii,jj)).GT.3) THEN
            InReg(ii,jj,ireg)= 1
          ENDIF
        ENDDO
        ENDDO

      ireg= iSpecReg + 3
C +...All OECAN/SEA-ICE points except excluded boundary
        DO jj= iexcl,my-iexcl
        DO ii= iexcl,mx-iexcl
          IF (NINT(MARisol(ii,jj)).LT.3) THEN
            InReg(ii,jj,ireg)= 1
          ENDIF
        ENDDO
        ENDDO

      ireg= iSpecReg + 4
C +...All ICE SHEET points except excluded boundary
        DO jj= iexcl,my-iexcl
        DO ii= iexcl,mx-iexcl
          IF (NINT(MARisol(ii,jj)).EQ.3) THEN
            InReg(ii,jj,ireg)= 1
          ENDIF
        ENDDO
        ENDDO

C +--Read sub-region definitions from file.
C +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C +
        RegDFile = 'RegDefs/'//REGstudy//'.RegD'
        OPEN(unit=51,status='unknown',file=RegDFile)
C +
        ireg= 0    
 980    CONTINUE
          READ (51,'(A21)',end=1010) INPstr
          IF (INPstr(1:1).EQ.'>') THEN
          
            IF (INPstr(2:7).EQ.'REGNUM') THEN
            
              READ (INPstr,'(8x,I4)') ireg
              WRITE(*,*) 'Reading def. for subregion ', ireg
              IF (ireg.GT.nreg) THEN 
                 STOP
              ENDIF
              READ (51,'(A21)') INPstr
              READ (INPstr,*) aLat, aLon
              READ (51,'(A21)') INPstr
              READ (INPstr,*) bLat, bLon
              DO jj= iexcl,my-iexcl
              DO ii= iexcl,mx-iexcl
                IF  (aLat.LE.MARlat(ii,jj)
     &          .AND.bLat.GE.MARlat(ii,jj)
     &          .AND.aLon.LE.MARlon(ii,jj)
     &          .AND.bLon.GE.MARlon(ii,jj) ) THEN
                  InReg(ii,jj,ireg)= 1
                  RegMsk(ii,jj)    = ireg
                ENDIF
              ENDDO
              ENDDO
              
            ELSE IF (INPstr(2:8).EQ.'STATION') THEN
            
              READ (INPstr,'(9x,I4)') ista
              WRITE(*,*) 'Reading def. for station ', ista
              IF (ista.GT.nsta) THEN 
                 STOP
              ENDIF
              READ (51,'(A21)') INPstr
              READ (INPstr,*) ii, jj ! Coordinates MAR
C                 on pourrait inclure une recherche du point
C                 le plus proche en lat/lon et eventuellement
C                 l'usage de plusieurs pts MAR avec poids/distance
              wmSta (ii,jj,ista)= 1.0 
              StaMsk(ii,jj)     = ista      
                               	 
            ENDIF
            
          ENDIF
        GOTO 980
      
 1010   CONTINUE
        CLOSE(unit=51) 
      END
