C   +-------------------------------------------------------------------+
C   +  Subroutine LSdom1                               Sept.96  LSMARIN +
C   +-------------------------------------------------------------------+
C   +                                                                   +
C   + Input : MAR grid -> mw     :                                      +
C   + ^^^^^^^             MARlon : longitude (degrees)                  +
C   +                     MARlat : latitude  (degrees)                  +
C   +                                                                   +
C   + Output: MARsh   : surface elevation                               +
C   + ^^^^^^^ isolSL  : soil type (ocean, snow, sea ice, continent)     +
C   +         MARd1   : surface heat capacity                           +
C   +         MARalb0 : surface albedo                                  +
C   +         MAReps0 : surface IR emissivity                           +
C   +         MARz0   : roughness length                                +
C   +         MARr0   : roughness length                                +
C   +         MARrsur : aerodynamic resistance                          +
C   +         MARch0  : bulk aerodynamic coefficient air/surface        +
C   +                    humidity flux                                  +
C   +                                                                   +
C   +-------------------------------------------------------------------+

      SUBROUTINE LSdom1 (mw,MARlon,MARlat,MARsh,MARalb0, MAReps0,
     .            MARz0,MARr0,MARd1,MARch0,MARrsur,isolSL,stypSL,
     .            veg_TV,fvegTV,iwflTV,rhosTV,alaiTV,glf_TV,ro_SL,
     .            zs_SL,zn_SL,zl_SL,cs2,dt0tg,wk0,wx0,w20,wg0,
     .            deridder,dx,sst_SL,LSfile,TOPObnd,MARnest,SNDfil)

      IMPLICIT NONE

C     LS and MAR domain dimensions :
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      INTEGER mx, my, mz, mzir1, mzir, mw
      INTEGER mx1, mx2, my1, my2, myd2, mz1, mzz, i_2, j_2, mzabso

      INCLUDE 'MARdim.inc'
      INCLUDE 'LSMARIN.inc'

C     General variables
C     ~~~~~~~~~~~~~~~~~
      INTEGER i,j,ierror
      REAL empty1(1)

C     MAR variables
C     ~~~~~~~~~~~~~
      INTEGER nbzc,TOPObnd

      REAL    cs2,dt0tg,wk0,wx0,w20,wg0,dx,zs_SL,zn_SL,zl_SL,
     .        sst_SL,MINlon,MAXlon,MINlat,MAXlat

      INTEGER isolSL(mx,my),veg_TV(mx,my,3),fvegTV(mx,my,3),
     .        stypSL(mx,my),iwflTV(mx,my)

      REAL    MARlon (mx,my),MARlat (mx,my),MARsh  (mx,my),
     .        MARd1  (mx,my),MARalb0(mx,my),MAReps0(mx,my),
     .        MARch0 (mx,my),MARrsur(mx,my),MARz0(mx,my,mw),
     .        MARr0  (mx,my,mw),ro_SL(mx,my),tmp1x5(mx,my,5),
     .        tmp2x5(mx,my,5),tmp2D(mx,my),rhosTV(mx,my),
     .        alaiTV(mx,my,3),glf_TV(mx,my,3)

      REAL    MARsnow(mx,my)

      LOGICAL deridder,belgium,MARnest,SNDfil

C     ETOPO variables
C     ~~~~~~~~~~~~~~~
      INTEGER TOPOid 
      CHARACTER*90 TOPOtit
      CHARACTER*20 var_units
      REAL TOPlon(TOPOmx), TOPlat(TOPOmy)   
      REAL TOPsh (TOPOmx,TOPOmy)
      REAL tmpTOP(TOPOmx,TOPOmy)

C     ECMWF variables
C     ~~~~~~~~~~~~~~~
      include 'LSM_WK3.inc'
C +...LS grid work area

      INTEGER LSfID
      CHARACTER *60 LSfile
      CHARACTER *90 LStitle
      REAL LSlon(LSni), LSlat(LSnj)

C +---GENERAL CONSTANTS
C     =================

C     ** Deardorff Soil Model Parameters :
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      cs2    = 86400.00
      w20    = 0.15
      wg0    = 0.10
      wk0    = 0.15
      wx0    = 0.20

C     ** Typical Roughness Lengths (m) :
C     ** (land, sea, snow) ~~~~~~~~~~~~~
C        ~~~~~~~~~~~~~~~~~
      zl_SL  = 1.00e-1
      zs_SL  = 1.00e-3
      zn_SL  = 1.00e-4

C     ** Inversion surface temperature :
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      dt0tg  = 0.


C     ####################################################################

C +---Topography
C     ==========

C     Topography data reading
C     -----------------------   

      WRITE(6,*) 'Read ', TOPOname
      WRITE(6,*)

      CALL UNropen (TOPOname, TOPOid, TOPOtit)

C          ******
      CALL UNread
     &    (TOPOid    ,'topo ' ,  0, 1, 1, 1,
     &     TOPOmx    ,TOPOmy  , 1     ,
     &     TOPlon    ,TOPlat  , empty1,
     &     var_units , TOPsh   )
C          ******

      CALL NCCLOS(TOPOid, ierror)


C     ** Check the extension of the domain
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      MINlon = MARlon(1,1)
      MAXlon = MARlon(1,1)
      MINlat = MARlat(1,1)
      MAXlat = MARlat(1,1)
      DO j=1,my
      DO i=1,mx
       MINlon = min(MARlon(i,j),MINlon)
       MAXlon = max(MARlon(i,j),MAXlon)
       MINlat = min(MARlat(i,j),MINlat)
       MAXlat = max(MARlat(i,j),MAXlat)
      ENDDO
      ENDDO

      IF (MINlon.lt.TOPlon(     1) .or.
     .    MAXlon.gt.TOPlon(TOPOmx) .or.
     .    MINlat.lt.TOPlat(     1) .or.
     .    MAXlat.gt.TOPlat(TOPOmy) ) THEN 

        write(*,*) 'SPECIFIED DOMAIN IS OUT OF ETOPO FILE'
        write(*,*)  MINlon,TOPlon(     1)     
        write(*,*)  MAXlon,TOPlon(TOPOmx)     
        write(*,*)  MINlat,TOPlat(     1)     
        write(*,*)  MAXlat,TOPlat(TOPOmy)         

        STOP

      ENDIF

      IF (MINlon.gt.(-3.) .and. MAXlon.lt.11. .and.
     .    MINlat.gt. 40.  .and. MAXlat.lt.60.) THEN
       belgium=.true.
      ELSE
       belgium=.false.
      ENDIF


C     ** Interpolation of topography to the MAR grid
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      CALL INTmean (tmpTOP,tmp1x5,tmp2x5,
     .              TOPOmx,TOPOmy,TOPlon,TOPlat,TOPsh,
     .              mx    ,my    ,MARlon,MARlat,MARsh)


C     ** Refined topography for Belgium
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      IF (belgium .and. dx.lt.9999.) THEN
       CALL L_TOPO (mx,my,dx,MARlon,MARlat,MARsh)
      ENDIF


C     ####################################################################


C +---ETOPO SOIL TYPES
C     ================

C     ---------------------------------------------------
C     Soil types are estimated related to the topography.
C     It could be improved with FAO data file (depending
C     on the MAR domain).
C
C     SOIL = 1  --->  ocean        (z =< 0 m.  )
C          = 2  --->  sea ice      (     -     )
C          = 3  --->  snow field   (z > 2000 m.)
C          = 4  --->  continent    (other cases)
C
C     CONTINENT TYPE = 2  (default)
C     ---------------------------------------------------

      DO j=1,my
      DO i=1,mx

       IF (sst_SL.gt.271.2) THEN

C       Continent + ocean + (snow ?)
C       ----------------------------

        IF      (MARsh(i,j).le.0.01 ) THEN
         isolSL(i,j)=1
        ELSE IF (MARsh(i,j).lt.2000.) THEN
         isolSL(i,j)=4
        ELSE
         isolSL(i,j)=3
        END IF

       ELSE

C       Snow + ice
C       ----------

        IF      (MARsh(i,j).le.0.01 ) THEN
         isolSL(i,j)=2
        ELSE
         isolSL(i,j)=3
        ENDIF

       ENDIF

       stypSL(i,j)=2

      ENDDO
      ENDDO


C     No atmosphere below sea level...
C     --------------------------------

      DO j=1,my
      DO i=1,mx

       IF (MARsh(i,j).lt.0.0) THEN
         MARsh(i,j)= 0.0
       ENDIF

      ENDDO
      ENDDO


C     ####################################################################

C     ECMWF SOIL TYPE   
C     ===============

C     Change continent to snow if according to ECMWF file
C     ---------------------------------------------------
C     Warning: first step of ECMWF file only ?

      IF (.not.SNDfil) THEN

       write(*,*) 'WARNING: ECMWF snow -> simple soil types' 
       write(*,*) 'add a selector to desable this ?'

       CALL UNropen (LSfile, LSfID, LStitle)

C           ******
       CALL UNread
     &    (LSfID    ,'SD '  ,1 , 1, LSbi, LSbj,
     &     LSni     ,LSnj   , 1   ,
     &     LSlon    ,LSlat  , empty1,
     &     var_units,wkV_LS  )
C           ******
C      Reads Snow Depth from ECMWF file.
C      (water equivalent, Kg/m2)

       CALL INThor (1,
     &    LSlon , LSlat, wkV_LS,
     &    MARlon, MARlat, MARsnow)
C      Interpolate to MAR grid (type 1= linear)

       CALL NCCLOS(LSfID, ierror)


       DO j=1,my
       DO i=1,mx

        IF (isolSL(i,j).EQ.4 .AND. MARsnow(i,j).GT.0.01) THEN
         isolSL(i,j)= 3
C        ^^^ Snow in ECMWF data + continent in MAR => snow
        ENDIF

       ENDDO
       ENDDO

      ENDIF
    
  
C     ####################################################################

C +---FAO SOIL TYPES
C     ==============

C     ------------------------------------
C     Source : FAO data file
C     Domain : 30 N -> 75 N, -25 W -> 60 E
C     ------------------------------------

C     --------------------------------------------------------
C     SOIL = 1  --->  ocean
C          = 4  --->  continent (soil model = Deardorff, 1978)
C                     ---> used only if "deardorff" variable 
C                          is .true. !!! 
C          = 5  --->  continent (soil model = De Ridder, 1994)
C     --------------------------------------------------------

C     --------------------------------------------------------
C     CONTINENT TYPE                     Deardorff  De Ridder
C     ~~~~~~~~~~~~~~                     ~~~~~~~~~  ~~~~~~~~~
C          = 1  (rough  texture)  --->   sand       loamy sand
C          = 2  (medium texture)  --->   silt       loam
C          = 3  (fine   texture)  --->   clay       clay
C     --------------------------------------------------------


      WRITE(6,*) 'Read FAO Soil Types .......'
      WRITE(6,*) '~~~~~~~~~~~~~~~~~~~~~~~~~~~'
      WRITE(6,*)

      CALL SOIL_TYPE (mx,my,dx,dx,MARlon,MARlat,isolSL,stypSL)


C     If the De Ridder SVAT model is not used ...
C     -------------------------------------------

      IF (.not.deridder) THEN
       DO j=1,my
       DO i=1,mx
        IF (isolSL(i,j).eq.5)  isolSL(i,j)=4
       ENDDO
       ENDDO
      ENDIF


C     ####################################################################


C +---LAND USE (Belgium)  --> used only with the De Ridder SVAT model
C     ==================      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

C     --------------------------------
C     USE = 1  --->  Agricultural crop
C         = 2  --->  Evergreen forest
C         = 3  --->  Coniferous forest
C         = 4  --->  Natural prairie
C         = 5  --->  Semi-desert
C         = 6  --->  City
C         = 7  --->  Water
C     --------------------------------


      IF (deridder) THEN

       WRITE(6,*) 'De Ridder SVAT model used --> ',
     .            'Read Global Landuse and NDVI index'
       WRITE(6,*) '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',
     .            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
       WRITE(6,*)

       CALL VEG_TYPE (mx,my,dx,dx,MARlon,MARlat,isolSL,veg_TV,
     .                     fvegTV,iwflTV,rhosTV,alaiTV,glf_TV)

       belgium=.false.

       IF (belgium) THEN

        WRITE(6,*) 'De Ridder SVAT model used --> ',
     .             'Read Landuse of Belgium ...'
        WRITE(6,*) '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',
     .             '~~~~~~~~~~~~~~~~~~~~~~~~~~~'
        WRITE(6,*)

        CALL B_LANDUSE (mx,my,dx,dx,MARlon,MARlat,MINlon,MINlat,
     .                  MAXlon,MAXlat,veg_TV,fvegTV)

       ENDIF

      ENDIF


C     ####################################################################


C +---TOPOGRAPHY FILTERING AND ADAPTATION IN BOUNDARY REGION
C     ======================================================

      CALL C_TOPO (MARlon,MARlat,dx,MARsh,LSfile,TOPObnd,MARnest)


C     ####################################################################


C +---SURFACE CHARACTERISTICS
C     =======================

      DO j=1,my
      DO i=1,mx

       GO TO (100,200,300,400) isolSL(i,j)

C      1. Ocean
C      ~~~~~~~~    

100    MARd1  (i,j)   = 0.
       MARalb0(i,j)   = 0.15
       MAReps0(i,j)   = 0.97
       MARz0  (i,j,1) = zs_SL
       MARz0  (i,j,2) = zs_SL
       MARr0  (i,j,1) = 0.1*MARz0(i,j,1)
       MARr0  (i,j,2) = 0.1*MARz0(i,j,2)
       MARch0 (i,j)   = 0.00132
       MARrsur(i,j)   = 0.0
       goto 500

C      2. Sea Ice
C      ~~~~~~~~~~

200    MARd1  (i,j)   = 1.05d+5
       MARalb0(i,j)   = 0.85d00
       MAReps0(i,j)   = 0.97d00
       MARz0  (i,j,1) = zn_SL
       MARz0  (i,j,2) = zn_SL
       MARr0  (i,j,1) = 0.1*MARz0(i,j,1)
       MARr0  (i,j,2) = 0.1*MARz0(i,j,2)
       MARch0 (i,j)   = 0.0021
C      ^ (Kondo and Yamazaki, 1990, JAM 29, p.376)
       MARrsur(i,j)   = 0.0
       go to 500


C      3. Snow Field
C      ~~~~~~~~~~~~~

300    MARd1  (i,j)   = 1.05e+5
       MARalb0(i,j)   = 0.85           
C      ^ albedo
       MAReps0(i,j)   = 0.97
       MARz0  (i,j,1) = zn_SL
       MARz0  (i,j,2) = zn_SL
       MARr0  (i,j,1) = 0.1*MARz0(i,j,1)
       MARr0  (i,j,2) = 0.1*MARz0(i,j,2)
       MARch0 (i,j)   = 0.0021
C      ^ (Kondo and Yamazaki, 1990, JAM 29, p.376)
       MARrsur(i,j)   = 0.0
       goto 500

C      4. Continent  
C      ~~~~~~~~~~~~

400    CONTINUE 

       IF (stypSL(i,j).eq.1) THEN
        MARd1  (i,j)  = 1.65e+5
        MARalb0(i,j)  = 0.40
C       ^ Dry Quartz Sand (Deardorff 1978 JGR p.1891)
       ELSE IF (stypSL(i,j).eq.3) THEN
        MARd1  (i,j)  = 7.55e+5
        MARalb0(i,j)  = 0.15
C       ^ Clay Pasture    (Deardorff 1978 JGR p.1891)
       ELSE
        MARd1  (i,j)   = 2.88e+5
        MARalb0(i,j)   = 0.25
C       ^ O'Neill average (Deardorff 1978 JGR p.1891)
       ENDIF
       MAReps0(i,j)   = 0.97
       MARz0  (i,j,1) = zl_SL
       MARz0  (i,j,2) = zl_SL
       MARr0  (i,j,1) = 0.1*MARz0(i,j,1)
       MARr0  (i,j,2) = 0.1*MARz0(i,j,2)
       MARch0 (i,j)   = 0.0025
       MARrsur(i,j)   = 200.0
       goto 500

500    CONTINUE

C      All soil types :
C      ~~~~~~~~~~~~~~~~
       ro_SL(i,j) = 0.0  !'not' initialised until now (see iniphy.f)

      ENDDO
      ENDDO


C     ####################################################################

      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7----
