
C   +-------------------------------------------------------------------+
C   | Subroutine INTmean                               1996.09  LSMARIN |
C   +-------------------------------------------------------------------+
C   |  * BILINEAR interpolation of a 2D scalar field:                   |
C   |                                                                   |
C   |  INPUT : grd_Ix (dim_Ix)         : Input grid points position x(i)|
C   |  ^^^^^^^ grd_Iy (dim_Iy)         :   "     "    "       "     y(j)|
C   |          var_I  (dim_Ix, dim_Iy) : Input field values             |
C   |          grd_Ox (dim_Ox, dim_Oy) : Output grid positions x(i,j)   |
C   |          grd_Oy (dim_Ox, dim_Oy) : Output grid positions y(i,j)   |
C   |                                                                   |
C   |          dim_Ix, dim_Iy : (parameter type) array dimensions       |
C   |                           ! = size of the interpolated data field |
C   |          dim_Ox, dim_Oy : (parameter type) array dimensions       |
C   |                           = size of the used data field           |
C   |                                                                   |
C   |  OUTPUT: var_O  (dim_Ox, dim_Oy) : Output field values            |
C   |  ^^^^^^^                                                          |
C   |  TEMPORARY arrays : tmp_in (dim_Ix, dim_Iy)                       |
C   +-------------------------------------------------------------------+
      SUBROUTINE INTmean   (tmp_in,       
     &       dim_Ix, dim_Iy, grd_Ix, grd_Iy, var_I, 
     &       dim_Ox, dim_Oy, grd_Ox, grd_Oy, var_O)

      IMPLICIT NONE


C     ** input
      INTEGER dim_Ix, dim_Iy
      INTEGER dim_Ox, dim_Oy
      REAL grd_Ix (dim_Ix),         grd_Iy (dim_Iy)
      REAL grd_Ox (dim_Ox, dim_Oy), grd_Oy (dim_Ox, dim_Oy)
      REAL var_I  (dim_Ix, dim_Iy)

C     ** output
      REAL var_O  (dim_Ox, dim_Oy)

C     ** temporary arrays:
      REAL tmp_in  (dim_Ix, dim_Iy)

C     ** local:
      INTEGER   LocDim
      PARAMETER(LocDim=4500) ! dim of Local 1D arrays
      INTEGER i,j,ii,jj,p,q,is
      REAL x,y,tmp,tmp2,x0,x1,y0,y1
      REAL tmp_Ix(0:LocDim+1)
      REAL tmp_Iy(0:LocDim+1)
      INTEGER icc(0:LocDim+1), jcc(-1:LocDim+1)
      LOGICAL cyclic
      
      INTEGER icheck
      icheck = 0     ! Debbuging output level
       
      cyclic = .FALSE. 
C +.. This routine sets cyclic to T automatically
C +.. If data boundary is crossed. 

      IF (icheck.ge.1) WRITE(*,*) 'INTmean : Begin'
      IF (dim_Ix.gt.LocDim .or. dim_Iy.gt.LocDim) THEN
        WRITE(*,*) 'INTmean - fatal error: dimension',LocDim
        WRITE(*,*) ' (change LocDim or correct CALL error)'
        STOP
      ENDIF


C +---Coordinates indexes inversion (if necessary).
C +   ---------------------------------------------
C     (tmp is used to keep input data unmodified.)

      DO jj = 1,dim_Iy
        DO ii = 1,dim_Ix 
          tmp_in (ii,jj) = var_I(ii, jj)
        ENDDO
      ENDDO
      DO ii = 1,dim_Ix
        tmp_Ix (ii) = grd_Ix (ii)
      ENDDO
      DO jj = 1,dim_Iy
        tmp_Iy (jj) = grd_Iy (jj)
      ENDDO

C     ** Revert grd_Ix (1) <--> grd_Ix (n), ... ?
      
      IF (grd_Ix(dim_Ix).lt.grd_Ix(1)) THEN     
        DO ii = 1,dim_Ix   
          DO jj = 1,dim_Iy                       
           tmp_in (ii,jj) = var_I(dim_Ix-ii+1, jj)
          ENDDO
          tmp_Ix (ii) = grd_Ix (dim_Ix-ii+1) 
        ENDDO
      IF(icheck.ge.2)WRITE(*,*)'Lon. coord. indexes reverted'
      ENDIF

C     ** Revert grd_Iy (1) <--> grd_Iy (n), ... ?
      
      IF (grd_Iy(dim_Iy).lt.grd_Iy(1)) THEN     
        DO jj = 1,dim_Iy   
          DO ii = 1,dim_Ix                       
           tmp_in (ii,jj) = var_I(ii,dim_Iy-jj+1)
          ENDDO
          tmp_Iy (jj) = grd_Iy (dim_Iy-jj+1)
        ENDDO
      IF(icheck.ge.2)WRITE(*,*)'Lat. coord. indexes reverted'
      ENDIF

C +---Define index conversion if cyclic field:
C     ----------------------------------------
      DO ii = 1,dim_Ix
        icc(ii)= ii
      ENDDO
      DO jj = 1,dim_Iy
        jcc(jj)= jj
      ENDDO
      icc(0)        = dim_Ix
      jcc(0)        = 1
      icc(dim_Ix+1) = 1
      jcc(dim_Iy+1) = dim_Iy
C +..Longitude is cyclic but latitude is "limited"

      tmp_Ix(0)        = 2.*tmp_Ix(1)-tmp_Ix(2)
      tmp_Ix(dim_Ix+1) = 2.*tmp_Ix(dim_Ix)-tmp_Ix(dim_Ix-1) 
C +..Define the "cross boundary" longitude.

      tmp_Iy(0)        = 2.*tmp_Iy(1)-tmp_Iy(2)
      tmp_Iy(dim_Iy+1) = 2.*tmp_Iy(dim_Iy)-tmp_Iy(dim_Iy-1)
C +..Define the "cross boundary" latitude. 


C +---Bi-linear interpolation.
C     ------------------------
C
C     ** Initial values for searching input mesh
C     ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
      p = 1
      q = 1
      
      DO i=1,dim_Ox    ! LOOP on output grid-points : BEGIN
       DO j=1,dim_Oy  
          
C      ** initialise tmp2 (to sum sampled values):
       tmp2 = 0.0

        x = samOx(i,j,is)
        y = samOy(i,j,is)

C       ** search for the bottom-left corner of the surrounding mesh :
C       ** (This simple method accounts for the fact that two
C       **  successive requests usually refer to neighbour points)
C       --------------------------------------------------------------

C +-----search for dimension 1 value
C +     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        IF (tmp_Ix(p).le.x) THEN

C         ** Search upwards
          DO WHILE (tmp_Ix(p+1).lt.x)
            p = p + 1
          END DO
        ELSE
C         ** Search downwards
          DO WHILE (tmp_Ix(p).gt.x)
            p = p - 1
          END DO
        END IF

C +-----search for dimension 2 value
C +     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        IF (tmp_Iy(q).le.y ) THEN
C         ** Search upwards
          DO WHILE (tmp_Iy(q+1).lt.y)
            q = q + 1
          END DO
        ELSE
C         ** Search downwards
          DO WHILE (tmp_Iy(q).gt.y)
            q = q - 1
          END DO
        END IF
        IF (icheck.ge.3) WRITE(*,*) tmp_Ix(p),tmp_Iy(q),x,y

C +-----interpolation
C +     ~~~~~~~~~~~~~

        x0 = tmp_Ix(icc(p))
        x1 = tmp_Ix(icc(p+1))
        y0 = tmp_Iy(jcc(q))
        y1 = tmp_Iy(jcc(q+1))
        tmp=(x-x0)*((y-y0)*tmp_in(icc(p+1),jcc(q+1))
     &             +(y1-y)*tmp_in(icc(p+1),jcc(q  )))
     &     +(x1-x)*((y-y0)*tmp_in(icc(p  ),jcc(q+1))
     &             +(y1-y)*tmp_in(icc(p  ),jcc(q  )))
        tmp2 = tmp2 + tmp / ( (x1-x0)*(y1-y0) )
        IF (icheck.ge.3) WRITE(*,*) tmp , x, y, p, q

        IF (p.lt.1 .OR. q.lt.1 
     &    .OR. p.gt.dim_Ix .OR. q.gt.dim_Iy ) THEN 
          cyclic = .TRUE.
        ENDIF

       END DO         ! LOOP on the sampling points: END

C +----output value = average of the samplings:
C +    ----------------------------------------
       var_O(i,j) = tmp2 / REAL(ns)

      END DO
      END DO          ! Loop on output grid-points : END

      IF (cyclic)WRITE(*,*) 'INTmean-info: cyclic boundaries'

      IF (icheck.ge.2) WRITE(*,*) 'INTmean : End'
      END
